/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.steam;

import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamLeaderboardEntriesHandle;
import com.codedisaster.steamworks.SteamLeaderboardEntry;
import com.codedisaster.steamworks.SteamLeaderboardHandle;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUserStatsCallback;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.screens.leaderboards.LeaderboardEntry;
import com.megacrit.cardcrawl.steam.SteamSaveSync;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSCallback
implements SteamUserStatsCallback {
    private static final Logger logger = LogManager.getLogger(SSCallback.class.getName());

    @Override
    public void onGlobalStatsReceived(long arg0, SteamResult arg1) {
        logger.info("1Bloop: " + arg0);
    }

    @Override
    public void onLeaderboardFindResult(SteamLeaderboardHandle handle, boolean found) {
        logger.info("onLeaderboardFindResult");
        if (found) {
            switch (SteamSaveSync.task) {
                case UPLOAD: {
                    SteamSaveSync.lbHandle = handle;
                    SteamSaveSync.uploadLeaderboardHelper();
                    break;
                }
                case RETRIEVE: {
                    SteamSaveSync.lbHandle = handle;
                    SteamSaveSync.getLeaderboardEntryHelper();
                    break;
                }
            }
        }
    }

    @Override
    public void onLeaderboardScoreUploaded(boolean success, SteamLeaderboardHandle handle, int score, boolean changed, int globalRankNew, int globalRankPrevious) {
        if (!success) {
            logger.info("Failed to upload leaderboard data: " + score);
        } else if (!changed) {
            logger.info("Leaderboard data not changed for data: " + score);
        } else {
            logger.info("Successfully uploaded leaderboard data: " + score);
        }
        SteamSaveSync.didCompleteCallback(success);
    }

    @Override
    public void onLeaderboardScoresDownloaded(SteamLeaderboardHandle handle, SteamLeaderboardEntriesHandle entries, int numEntries) {
        logger.info("Downloaded " + numEntries + " entries");
        int[] details = new int[16];
        CardCrawlGame.mainMenuScreen.leaderboardsScreen.entries.clear();
        for (int i = 0; i < numEntries; ++i) {
            SteamLeaderboardEntry entry = new SteamLeaderboardEntry();
            if (SteamSaveSync.steamStats.getDownloadedLeaderboardEntry(entries, i, entry, details)) {
                int rTemp = entry.getGlobalRank();
                if (i == 0) {
                    CardCrawlGame.mainMenuScreen.leaderboardsScreen.currentStartIndex = rTemp;
                } else if (i == numEntries) {
                    CardCrawlGame.mainMenuScreen.leaderboardsScreen.currentEndIndex = rTemp;
                }
                CardCrawlGame.mainMenuScreen.leaderboardsScreen.entries.add(new LeaderboardEntry(rTemp, SteamSaveSync.steamFriends.getFriendPersonaName(entry.getSteamIDUser()), entry.getScore(), SteamSaveSync.gettingTime, SteamSaveSync.accountId != -1 && SteamSaveSync.accountId == entry.getSteamIDUser().getAccountID()));
                continue;
            }
            logger.info("FAILED TO GET LEADERBOARD ENTRY: " + i);
        }
        CardCrawlGame.mainMenuScreen.leaderboardsScreen.waiting = false;
    }

    @Override
    public void onUserAchievementStored(long arg0, boolean arg1, String arg2, int arg3, int arg4) {
        logger.info("Achievement Stored");
    }

    @Override
    public void onUserStatsReceived(long arg0, SteamID arg1, SteamResult arg2) {
        logger.info("SteamID: " + arg1.getAccountID());
        logger.info("APPID: " + arg0);
    }

    @Override
    public void onUserStatsStored(long arg0, SteamResult arg1) {
        logger.info("Stat Stored");
    }

    @Override
    public void onUserStatsUnloaded(SteamID arg0) {
        logger.info("8Bloop");
    }
}

